/* pxplus-ace helper javascript - Common functions used by ace editor object */

var idAceTimer = null;
var aryAceEditors = new Array();
var nSignal = 0;

function DoUndo(oEdit)
{	if (oEdit.pxplus_chg_delay == 0) oEdit.pxplus_next_chg = true;
	oEdit.undo(false);
	if (oEdit.pxplus_chg_delay > 2) oEdit.pxplus_chg_tmr = oEdit.pxplus_chg_delay - 1;
	return oEdit.getSession().getUndoManager().hasUndo();
}
  
function DoRedo(oEdit)
{	if (oEdit.pxplus_chg_delay == 0) oEdit.pxplus_next_chg = true;
	oEdit.redo();
	if (oEdit.pxplus_chg_delay > 2) oEdit.pxplus_chg_tmr = oEdit.pxplus_chg_delay - 1;
	return oEdit.getSession().getUndoManager().hasRedo();
}

function AceInit(oEdit, sId, nTabSize, bShowInvisibles)
{	oEdit.pxplus_sId = sId;
	oEdit.pxplus_next_chg = 0;
	oEdit.pxplus_chg_delay = 0;
	oEdit.pxplus_chg = 0;
	oEdit.pxplus_chg_tmr = 0;
	oEdit.getSession().setUseSoftTabs(false);
	oEdit.getSession().setTabSize(nTabSize);
	oEdit.setShowInvisibles(bShowInvisibles);
	oEdit.on('change', function() { AceChange(oEdit); } );
	oEdit.on('blur', function(){ AceBlur(oEdit); } );
	aryAceEditors.push(oEdit);
	idAceTimer = setInterval(AceTimer, 1000);
}

function AceSave(oEdit)
{	AceSignal(oEdit, "save");
}

function AceChange(oEdit)
{	if (oEdit.pxplus_next_chg == 2) return;

	if (typeof webster !== 'undefined' && webster) _Id('isChangeId').value=1;
	oEdit.pxplus_chg = true;
	if ((oEdit.pxplus_chg_delay < 0) || (oEdit.pxplus_next_chg))
	{	AceSignalChg(oEdit);
		return;
	}
}

function AceBlur(oEdit)
{	AceSignal(oEdit, "blur");
	return;
}

function AceSignalNextChg(oEdit)
{	oEdit.pxplus_next_chg = 1;
}

function AceSignalChg(oEdit)
{	oEdit.pxplus_chg_tmr = 0;
	oEdit.pxplus_next_chg = 0;

	AceSignal(oEdit, "chg");
}

function AceTimer()
{	var oEdit;

	for (var i = 0; i < aryAceEditors.length; i++)
	{	oEdit = aryAceEditors[i];
		if (oEdit.pxplus_chg_delay > 0)
		{	oEdit.pxplus_chg_tmr++;
			if (oEdit.pxplus_chg)
			{	if ((oEdit.pxplus_chg_tmr > oEdit.pxplus_chg_delay) || (oEdit.getCursorPosition().row != oEdit.pxplus_chg_line)) AceSignalChg(oEdit);
			}
		}
	}
}

function AceSetChangeDelay(oEdit, nSec)
{	oEdit.pxplus_chg_delay = nSec;
}

function AceSignal(oEdit, sCmd)
{	if (oEdit.pxplus_chg)
		sCmd += ',1';
	else
		sCmd += ',0';
	
	if (typeof iNmd_Signal == 'function') 
	{	iNmd_Signal(oEdit.pxplus_sId, sCmd);
	}
	else if (typeof webster !== 'undefined' && webster)
	{	oEdit.pxplus_chg_line = oEdit.getCursorPosition().row;
		if (oEdit.pxplus_chg)
		{	_Id('saveCode').value=oEdit.getValue();
			_Evt('form_1','change','');
		}
		if (sCmd.startsWith('save'))
			_Evt('form_1','save','');
	}
	else
	{	nSignal++;
		document.title = 'Sig#' + nSignal+ ':' + sCmd;
	}
}
function AceLoad(oEdit, sValue)
{	oEdit.pxplus_next_chg = 2;
	oEdit.setValue(sValue);
	
	oEdit.clearSelection();
	oEdit.pxplus_chg_tmr = 0;

}

function AceStatus(oEdit)
{	var oCursor = oEdit.selection.getCursor();
	var oUndo = oEdit.getSession().getUndoManager();

	var sInfo = 
		oCursor.row.toString() + ',' + 
		oCursor.column.toString() + ',' + 
		oEdit.getSession().getScrollTop().toString() + ',' + 
		(oUndo.hasUndo() ? '1,' : '0,') + 
		(oUndo.hasRedo() ? '1' : '0');

	var sVal = '';
	if (oEdit.pxplus_chg)
	{	oEdit.pxplus_chg = false;
		oEdit.pxplus_chg_line = oEdit.getCursorPosition().row;
		oEdit.pxplus_chg_tmr = 0;
		sVal =  ',' + oEdit.getValue();
	}
	return sInfo + sVal;
}
function AceGetPosition(oEdit)
{	var oCursor = oEdit.selection.getCursor();
	return oCursor.row.toString() + ',' + oCursor.column.toString() + ',' + oEdit.getSession().getScrollTop().toString();
}

function AceSetPosition(oEdit, nRow, nCol, nTop, nReset)
{	oEdit.gotoLine(nRow+1, nCol, false);
	if (nTop < 0)
		oEdit.scrollToLine(nRow+1, true, false, null);
	else
		oEdit.getSession().setScrollTop(nTop);

	if (!nReset) return;

	oEdit.getSession().getUndoManager().reset();
	oEdit.pxplus_chg = 0;
}


function PropDump(objectname, object) 
{	var wNew = window.open('','','height=600,width=800,toolbar=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,location=no');
	var sVal;
	
	wNew.document.writeln('<html><body>');

	wNew.document.writeln("<table border=1 bgcolor=wheat><tr>");
	wNew.document.writeln("<td style='font-size: 18pt; font-weight: bold' colspan=2 align=center>");
	wNew.document.writeln("Properties of the <code>"+objectname+"</code> object</td></tr>");

	for (prop in object)
	{	if ((prop == 'innerHTML') || (prop == 'outerHTML'))
			sVal = "..suppressed..";
		else
			sVal =  object[prop];

		wNew.document.writeln("<tr><th>"+prop+"</th><td>" +  sVal +"</td></tr>");
	}

	wNew.document.writeln("</table><p>");
	wNew.document.writeln('</body></html>');
	wNew.document.close();
	return;
}

function AceSearch(oEdit, isReplace)
{	 ace.config.loadModule("ace/ext/searchbox", function(e) {e.Search(oEdit, isReplace)});
}
